<?php
/**
 * Report Sales Orders Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */
use libraries\BaseController;

class Report_sales_orders extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Sales_orders_model');
		$this->load->model('Customers_model');
		$this->load->model('Items_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
 	{	
        $data['content_title'] = 'Laporan Penjualan';
        $data['customer_data'] = $this->Customers_model->get_data()->result();
        $data['item_data']     = $this->Items_model->get_data()->result();
		
		$this->twiggy_display('adm/report_sales_orders/index', $data);
	}

	public function get_data_detail()
	{	
		$customer = $this->input->post("customer");
		$item     = $this->input->post("item");
		$ppn      = $this->input->post("ppn");
		$fromdate = $this->input->post("fromdate");
		$todate   = $this->input->post("todate");

        $data  = [];
		$where = [];
		$order = ("printed_date ASC, sales_order_header_number");

        if(isset($customer) && $customer != '' && $customer != '(Semua)')
		{
			$where['sales_order_header_customer_id'] = $customer;
		}
		if(isset($item) && $item != '' && $item != '(Semua)')
		{
			$where['sales_order_detail_item_id'] = $item;
		}
		if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
		{
			$where['sales_order_detail_ppn_status'] = $ppn;
		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['printed_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['printed_date <='] = change_format_date($todate);
		}
		
		$get_data    = $this->Sales_orders_model->salesorder_detail_advance($where, $order, 'sales_order_header_id')->result();
		$grand_total = 0;

		// ketika data tersedia
		// maka generate data json untuk Datatable

		$line = 1;
		if($get_data)
		{
			$no = 1;
			foreach($get_data as $k => $get_row)
			{	

				$a = 0;
				$sales_total = ($get_row->sales_order_header_grand_total - $get_row->sales_order_header_ppn_total);
				if(isset($item) && $item != '' && $item != '(Semua)')
				{
					$sales_total = $a += ($get_row->sales_order_detail_result_large + $get_row->sales_order_detail_result_medium + $get_row->sales_order_detail_result_small);
				}
				
				// $where_detail = array('sales_order_header_id' => $get_row->sales_order_header_id);
				$where['sales_order_header_id'] = $get_row->sales_order_header_id;
				$data[] = array(
					'sales_number' => $get_row->sales_order_header_number,
					'sales_total'  => number_format($this->Sales_orders_model->salesorder_detail_sum('', '', '', $where)->row()->result),
				);

				
				$gdata_detail = $this->Sales_orders_model->salesorder_detail_advance('', '', '', $where)->result();
                

				$rowspan = 1;
				foreach ($gdata_detail as $key => $value) {

					$ppn_status       = $get_row->sales_order_detail_ppn_status;
					$ppn_status_color = '';

					if($ppn_status == '1'){
						$faktur = $value->faktur_1;
					}
					if($ppn_status == '2'){
						$ppn_status_color = 'cl-success';
					}
					if($ppn_status == '3'){
						$ppn_status_color = 'cl-warning';
					}

					$faktur = trim(($value->faktur_1 != "0" ? $value->faktur_1 : "")." ".($value->faktur_2 != "0" ? $value->faktur_2 : "")." ".($value->faktur_3 != "0" ? $value->faktur_3 : ""));
					if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
					{	
						if($ppn == '1'){
							$faktur = $value->faktur_1;
						}
						if($ppn == '2'){
							$faktur = $value->faktur_2;
						}
						if($ppn == '3'){
							$faktur = $value->faktur_3;
						}
					}

					$data[$k]['detail'][$key] = array(	
						'no'               => $no,
						'detail_rowspan'   => $rowspan,
						'detail_line'      => $line,
						'sales_number'     => $value->sales_order_header_number,
						'faktur_number'    => $faktur,
						'customer'         => $value->customer_name,
						'faktur_1'         => ($value->faktur_1 == "0" ? "" : $value->faktur_1),
						'faktur_2'         => ($value->faktur_2 == "0" ? "" : $value->faktur_2),
						'faktur_3'         => ($value->faktur_3 == "0" ? "" : $value->faktur_3),
						'sales_date'       => change_format_date($value->printed_date, 'd/m/Y'),
						'item_name'        => $value->sales_order_detail_item_name,
						'lg_unit'          => ($value->sales_order_detail_large_unit_quantity  > 0 ? $value->sales_order_detail_large_unit : ''),
						'lg_unit_qty'      => ($value->sales_order_detail_large_unit_quantity  > 0 ? to_decimal($value->sales_order_detail_large_unit_quantity) : ''),
						'lg_unit_prc'      => ($value->sales_order_detail_large_unit_quantity  > 0 ? number_format($value->sales_order_detail_large_unit_price) : ''),
						'md_unit'          => ($value->sales_order_detail_medium_unit_quantity > 0 ? $value->sales_order_detail_medium_unit : ''),
						'md_unit_qty'      => ($value->sales_order_detail_medium_unit_quantity > 0 ? to_decimal($value->sales_order_detail_medium_unit_quantity) : ''),
						'md_unit_prc'      => ($value->sales_order_detail_medium_unit_quantity > 0 ? number_format($value->sales_order_detail_medium_unit_price) : ''),
						'sm_unit'          => ($value->sales_order_detail_small_unit_quantity  > 0 ? $value->sales_order_detail_small_unit : ''),
						'sm_unit_qty'      => ($value->sales_order_detail_small_unit_quantity  > 0 ? to_decimal($value->sales_order_detail_small_unit_quantity) : ''),
						'sm_unit_prc'      => ($value->sales_order_detail_small_unit_quantity  > 0 ? number_format($value->sales_order_detail_small_unit_price) : ''),
						'ppn_status_color' => $ppn_status_color,
						'total'            => number_format($value->sales_order_detail_result_large + $value->sales_order_detail_result_medium + $value->sales_order_detail_result_small),
						// 'total'            => number_format($value->sales_order_detail_total),
						'status' => $value->sales_order_detail_ppn_status,
						'is_hold'			 => ($value->is_hold == 1 ? 'bg-warning' : '')
					);
					$rowspan++;
					$line++;

					$grand_total += $value->sales_order_detail_result_large + $value->sales_order_detail_result_medium + $value->sales_order_detail_result_small;
					// $total_all_tunai    += $tunai;
					// $total_all_transfer += $transfer;
					// $total_all_method   += $t_all;
					
				}
				$no++;
			}
		}

		$this->session->set_userdata('customer', $customer);
		$this->session->set_userdata('item', $item);
		$this->session->set_userdata('ppn', $ppn);
		$this->session->set_userdata('fromdate', $fromdate);
		$this->session->set_userdata('todate', $todate);

		$response = [
			// 'date_1'             => ($date_1 == '' ? '' : change_format_date($date_1, 'd/m/Y')),
			// 'date_2'             => ($date_2 == '' ? '' : change_format_date($date_2, 'd/m/Y')),
			'detail_data' => $data,
			'grand_total' => number_format($grand_total),
			'total_transaksi' => number_format(count($get_data))
		];

		output_json($response);
	}

	public function export_excel() {

		$customer = $this->session->userdata('customer');
		$item     = $this->session->userdata('item');
		$ppn      = $this->session->userdata('ppn');
		$fromdate = $this->session->userdata('fromdate');
		$todate   = $this->session->userdata('todate');

		$where    = [];
		$order = ("printed_date ASC, sales_order_header_number");
		$customer_name = '-';
		$item_name = '-';

		$fromdate_text = ($fromdate == '' ? '-' : change_format_date($fromdate, 'd/m/Y'));
		$todate_text = ($todate == '' ? '-' : change_format_date($todate, 'd/m/Y'));

        if(isset($customer) && $customer != '' && $customer != '(Semua)')
		{
			$where['sales_order_header_customer_id'] = $customer;
			$customer_name = $this->Customers_model->get_data(array('customer_id' => $customer))->row()->customer_name;
		}
		if(isset($item) && $item != '' && $item != '(Semua)')
		{
			$where['sales_order_detail_item_id'] = $item;
			$item_name = $this->Items_model->get_data(array('item_id' => $item))->row()->item_name;
		}
		if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
		{
			$where['sales_order_detail_ppn_status'] = $ppn;
		}
		if(isset($fromdate) && $fromdate != '')
		{
			$where['printed_date >='] = change_format_date($fromdate);
		}
		if(isset($todate) && $todate != '')
		{
			$where['printed_date <='] = change_format_date($todate);
		}
		
		$get_data = $this->Sales_orders_model->salesorder_detail_advance($where, $order)->result();
		
		// Class PHPExcel
		$excel = new PHPExcel();
	    // Settingan awal file excel
		$excel->getProperties()->setCreator('TOKO TEST INDONESIA')
							   ->setLastModifiedBy('TOKO TEST INDONESIA')
							   ->setTitle("PENJUALAN")
							   ->setSubject("PENJUALAN")
							   ->setDescription("PENJUALAN")
							   ->setKeywords("PENJUALAN");

	    // Variabel untuk menampung pengaturan style dari header tabel
		$style_col = array(
			'font' => array(
				'bold' => true
	      	),
			'alignment' => array(
	        	'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,   // Set text jadi ditengah secara horizontal (center)
	        	'vertical'   => PHPExcel_Style_Alignment::VERTICAL_CENTER      // Set text jadi di tengah secara vertical (middle)
	        ),
			'borders' => array(
	        	'top'    => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border top dengan garis tipis
	        	'right'  => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border right dengan garis tipis
	        	'bottom' => array('style'  => PHPExcel_Style_Border::BORDER_THIN),   // Set border bottom dengan garis tipis
	        	'left'   => array('style'  => PHPExcel_Style_Border::BORDER_THIN)    // Set border left dengan garis tipis
	        ),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'FFCC00')
			)
		);

		$style_row_success = array(
			'font'  => array(
				'color' => array('rgb' => 'FFFFFF'),
			),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => '5cb85c')
			)
		);

		$style_row_warning = array(
			'font'  => array(
				'color' => array('rgb' => '000000'),
			),
			'fill' => array(
				'type'  => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb' => 'f0ad4e')
			)
		);

	    // Variabel untuk menampung pengaturan style dari isi tabel
		$style_row = array(
			'alignment' => array(
	        	 'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER  // Set text jadi di tengah secara vertical (middle)
   		 	),
			'borders' => array(
				    'allborders' => array(
					'style'      => PHPExcel_Style_Border::BORDER_THIN
				)
			)
		);

	    $excel->setActiveSheetIndex(0)->setCellValue('A1', "Penjualan");
	    $excel->getActiveSheet()->mergeCells('A1:Q1');
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setBold(TRUE);
	    $excel->getActiveSheet()->getStyle('A1')->getFont()->setSize(15);
	    $excel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_LEFT);

		// Buat header tabel pada baris ke 3
		$excel->setActiveSheetIndex(0)->setCellValue('A3', "Pelanggan");
		$excel->setActiveSheetIndex(0)->setCellValue('B3', ": ".$customer_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A4', "Nama Barang");
		$excel->setActiveSheetIndex(0)->setCellValue('B4', ": ".$item_name);
		$excel->setActiveSheetIndex(0)->setCellValue('A5', "Tanggal");
		$excel->setActiveSheetIndex(0)->setCellValue('B5', ": ".$fromdate_text." - ".$todate_text);

	    $excel->getActiveSheet()->mergeCells('A7:A8');
		$excel->getActiveSheet()->mergeCells('B7:B8');
		$excel->getActiveSheet()->mergeCells('C7:C8');
		$excel->getActiveSheet()->mergeCells('D7:D8');
		$excel->getActiveSheet()->mergeCells('E7:E8');
		$excel->getActiveSheet()->mergeCells('F7:F8');

		$excel->getActiveSheet()->mergeCells('G7:I7');
		$excel->getActiveSheet()->mergeCells('J7:L7');
		$excel->getActiveSheet()->mergeCells('M7:O7');

		$excel->getActiveSheet()->mergeCells('P7:P8');
		$excel->getActiveSheet()->mergeCells('Q7:Q8');

	    $excel->setActiveSheetIndex(0)->setCellValue('A7', "No.");
	    $excel->setActiveSheetIndex(0)->setCellValue('B7', "Nomor Penjualan");
	    $excel->setActiveSheetIndex(0)->setCellValue('C7', "Nomor Faktur");
	    $excel->setActiveSheetIndex(0)->setCellValue('D7', "Tanggal");
	    $excel->setActiveSheetIndex(0)->setCellValue('E7', "Pelanggan");
	    $excel->setActiveSheetIndex(0)->setCellValue('F7', "Nama Barang");
	    $excel->setActiveSheetIndex(0)->setCellValue('G7', "Satuan Besar");
		$excel->setActiveSheetIndex(0)->setCellValue('H7', "Satuan Sedang");
		$excel->setActiveSheetIndex(0)->setCellValue('I7', "Satuan Kecil");

		$excel->setActiveSheetIndex(0)->setCellValue('G8', "Satuan");
		$excel->setActiveSheetIndex(0)->setCellValue('H8', "Quantity");
		$excel->setActiveSheetIndex(0)->setCellValue('I8', "Harga");
		$excel->setActiveSheetIndex(0)->setCellValue('J8', "Satuan");
		$excel->setActiveSheetIndex(0)->setCellValue('K8', "Quantity");
		$excel->setActiveSheetIndex(0)->setCellValue('L8', "Harga");
		$excel->setActiveSheetIndex(0)->setCellValue('M8', "Satuan");
		$excel->setActiveSheetIndex(0)->setCellValue('N8', "Quantity");
		$excel->setActiveSheetIndex(0)->setCellValue('O8', "Harga");

		$excel->setActiveSheetIndex(0)->setCellValue('P7', "Total Harga");
		$excel->setActiveSheetIndex(0)->setCellValue('Q7', "Status");
	
	    // Apply style header
	    $excel->getActiveSheet()->getStyle('A7:A8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('B7:B8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('C7:C8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('D7:D8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('E7:E8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('F7:F8')->applyFromArray($style_col);
		
	    $excel->getActiveSheet()->getStyle('G7:I7')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('J7:L7')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('M7:O7')->applyFromArray($style_col);
		
	    $excel->getActiveSheet()->getStyle('G8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('H8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('I8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('J8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('K8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('L8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('M8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('N8')->applyFromArray($style_col);
		$excel->getActiveSheet()->getStyle('O8')->applyFromArray($style_col);

	    $excel->getActiveSheet()->getStyle('P7:P8')->applyFromArray($style_col);
	    $excel->getActiveSheet()->getStyle('Q7:Q8')->applyFromArray($style_col);


	    $no = 0; // Untuk penomoran tabel, di awal set dengan 1
	    $numrow = 9; // Set baris pertama untuk isi tabel adalah baris ke 9
		$numtrx = '';
		foreach($get_data as $get_row){ // Lakukan looping pada variabel row
			
			if($numtrx != $get_row->sales_order_header_id){
				$no++;
			}
			$numtrx = $get_row->sales_order_header_id;

			$faktur = trim(($get_row->faktur_1 != "0" ? $get_row->faktur_1 : "")." ".($get_row->faktur_2 != "0" ? $get_row->faktur_2 : "")." ".($get_row->faktur_3 != "0" ? $get_row->faktur_3 : ""));
			if(isset($ppn) && $ppn != '' && $ppn != '(Semua)')
			{	
				if($ppn == '1'){
					$faktur = $get_row->faktur_1;
				}
				if($ppn == '2'){
					$faktur = $get_row->faktur_2;
				}
				if($ppn == '3'){
					$faktur = $get_row->faktur_3;
				}
			}
			
			$excel->setActiveSheetIndex(0)->setCellValue('A'.$numrow, $no);
			$excel->setActiveSheetIndex(0)->setCellValue('B'.$numrow, $get_row->sales_order_header_number);
			$excel->setActiveSheetIndex(0)->setCellValue('C'.$numrow, $faktur);
			$excel->setActiveSheetIndex(0)->setCellValue('D'.$numrow, change_format_date($get_row->printed_date, 'd/m/Y'));
			$excel->setActiveSheetIndex(0)->setCellValue('E'.$numrow, $get_row->customer_name);
			$excel->setActiveSheetIndex(0)->setCellValue('F'.$numrow, $get_row->sales_order_detail_item_name);
			$excel->setActiveSheetIndex(0)->setCellValue('G'.$numrow, ($get_row->sales_order_detail_large_unit_quantity  > 0 ? $get_row->sales_order_detail_large_unit : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('H'.$numrow, ($get_row->sales_order_detail_large_unit_quantity  > 0 ? to_decimal($get_row->sales_order_detail_large_unit_quantity) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('I'.$numrow, ($get_row->sales_order_detail_large_unit_quantity  > 0 ? ($get_row->sales_order_detail_large_unit_price) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('J'.$numrow, ($get_row->sales_order_detail_medium_unit_quantity > 0 ? $get_row->sales_order_detail_medium_unit : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('K'.$numrow, ($get_row->sales_order_detail_medium_unit_quantity > 0 ? to_decimal($get_row->sales_order_detail_medium_unit_quantity) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('L'.$numrow, ($get_row->sales_order_detail_medium_unit_quantity > 0 ? ($get_row->sales_order_detail_medium_unit_price) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('M'.$numrow, ($get_row->sales_order_detail_small_unit_quantity  > 0 ? $get_row->sales_order_detail_small_unit : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('N'.$numrow, ($get_row->sales_order_detail_small_unit_quantity  > 0 ? to_decimal($get_row->sales_order_detail_small_unit_quantity) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('O'.$numrow, ($get_row->sales_order_detail_small_unit_quantity  > 0 ? ($get_row->sales_order_detail_small_unit_price) : ''));
			$excel->setActiveSheetIndex(0)->setCellValue('P'.$numrow, ($get_row->sales_order_detail_result_large + $get_row->sales_order_detail_result_medium + $get_row->sales_order_detail_result_small));
			// $excel->setActiveSheetIndex(0)->setCellValue('N'.$numrow, number_format($get_row->sales_order_detail_total));
			$excel->setActiveSheetIndex(0)->setCellValue('Q'.$numrow, $get_row->sales_order_detail_ppn_status);


			// Apply style row yang telah kita buat tadi ke masing-masing baris (isi tabel)
			// $ppn_status       = $get_row->sales_order_detail_ppn_status;

			$excel->getActiveSheet()->getStyle('A'.$numrow.':Q'.$numrow)->applyFromArray($style_row);
			// if($ppn_status == '2'){
			// 	$excel->getActiveSheet()->getStyle('A'.$numrow.':N'.$numrow)->applyFromArray($style_row_success);
			// }
			if($get_row->is_hold == '1'){
				$excel->getActiveSheet()->getStyle('A'.$numrow.':Q'.$numrow)->applyFromArray($style_row_warning);
			}

			$excel->getActiveSheet()->getStyle('I'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('L'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('O'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
			$excel->getActiveSheet()->getStyle('P'.$numrow)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

	      	 // Tambah 1 setiap kali looping
	      	$numrow++; // Tambah 1 setiap kali looping
		}
		 
	    // Set width
	    $excel->getActiveSheet()->getDefaultColumnDimension()->setWidth(30);

	    // Set height
		$excel->getActiveSheet()->getDefaultRowDimension()->setRowHeight(-1);
		
	    // Set orientasi kertas jadi LANDSCAPE
		$excel->getActiveSheet()->getPageSetup()->setOrientation(PHPExcel_Worksheet_PageSetup::ORIENTATION_LANDSCAPE);
		
	    // Set judul file excel
	    $excel->getActiveSheet(0)->setTitle("PENJUALAN");
		$excel->setActiveSheetIndex(0);
		
	    // Proses file excel
		$date_now = change_format_date(date_now(), 'Ymd');
		$filename = 'PENJUALAN_'.$date_now.'.xlsx';

	    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	    header('Content-Disposition: attachment; filename="'.$filename.'"'); // Set nama file excel nya
	    header('Cache-Control: max-age=0');
	    $write = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
	    $write->save('php://output');
	}

}

?>
